<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/P_KOP_RG.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Trader.xsd" xmlns:pkoprg="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/P_KOP_RG.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Trader.xsd" version="1.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="UTF-8" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {	font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> <xsl:value-of select="name()"/> </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_pkoprg" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_pkoprg"> <xsl:for-each select=" ns1:Header |  ns4:* | pkoprg:Header | tr:* "> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:apply-templates mode="rok_mc" select="."/> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:apply-templates mode="PodstawaPrawna" select="."/> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:apply-templates mode="MiejsceDekl" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:apply-templates mode="Adres" select="."/> <!-- SZABLON DOT. WYROBOW GAZOWYCH--> <xsl:apply-templates mode="WyrobyG" select="."/> <!-- SZABLON DOT. WYROBOW NAFTY--> <xsl:apply-templates mode="WyrobyN" select="."/> <!-- SZABLON DOT. KWOTY PODATKU --> <xsl:apply-templates mode="KwotaPodatku" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <!-- <xsl:apply-templates mode="Adnotacje" select="."/> --> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:apply-templates mode="ObjasnieniaAkc" select="."/> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" height="45" valign="middle" width="586"> <span class="cz12"> <b>1. Identyfikator podatkowy NIP podatnika </b> </span> </td> <td align="center" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" valign="top"> <td align="left" height="45" valign="top"> <b>Numer własny:</b> <span class="cz18"> <xsl:value-of select="@selfRef"/> </span> <br/> <b>Data wypełnienia deklaracji:</b> <span class="cz18"> <xsl:value-of select="substring(//@declarationDate,1,4)"/> <xsl:value-of select="substring(//@declarationDate,5,6)"/> </span> </td> <td align="center" valign="bottom"> <xsl:if test="@refNumber"> Nr referencyjny nadany przez System Zefir:<br/> <xsl:value-of select="@refNumber"/> </xsl:if> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:* | pkoprg:*"> <table border="1" width="956"> <tr> <td colspan="3" height="40"> <span class="nag1">P-KOP/RG</span> </td> </tr> <tr> <td height="61" width="154"/> <td width="537"> <div align="center"> <span class="nag1">DEKLARACJA DLA PODATKU OD WYDOBYCIA NIEKTÓRYCH KOPALIN W ZAKRESIE ROPY NAFTOWEJ LUB GAZU ZIEMNEGO</span> <br/> <span class="nag1"/> </div> </td> <td width="243"/> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <!-- SZABLON DOT.  OKRESU ROK MIESIAC --> <xsl:template match="*" mode="rok_mc"> <xsl:if test="ns1:* | pkoprg:*"> <table border="1" width="955"> <tr> <td height="49" width="247"/> <td align="left" valign="top" width="135"> <b>4. Miesiąc</b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,6,7)"/> </div> </td> <td align="left" valign="top" width="131"> <b>5. Rok </b> <br/> <div align="center" class="cz18"> <xsl:value-of select="substring(@period,1,4)"/> </div> </td> <td width="206"/> <td align="left" valign="top" width="206"> <br/> <div align="center" class="cz18"/> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <xsl:template match="*" mode="PodstawaPrawna"> <xsl:if test="ns1:* | pkoprg:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td align="left" valign="top" width="115">Podstawa prawna: </td> <td align="left" valign="top" width="824">Art. 14 ust. 1 pkt 1 ustawy z dnia 2 marca 2012 r. o podatku od wydobycia niektórych kopalin (Dz. U. z 2018 r. poz. 228), zwanej dalej „ustawą”  </td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Termin składania:</td> <td align="left" valign="top">Do 25 dnia miesiąca następującego po miesiącu, w którym powstał obowiązek podatkowy. </td> </tr> <tr bgcolor="#CCCCCC"> <td align="left" valign="top">Miejsce składania: </td> <td align="left" valign="top">Naczelnik urzędu skarbowego właściwy ze względu na adres siedziby podatnika – w przypadku osób prawnych albo jednostek organizacyjnych niemających osobowości prawnej, albo miejsce zamieszkania podatnika – w przypadku osób fizycznych; jeżeli nie jest możliwe określenie właściwości miejscowej w powyżej opisany sposób, właściwym naczelnikiem urzędu skarbowego w sprawie podatku od wydobycia niektórych kopalin w zakresie wydobycia gazu ziemnego lub ropy naftowej jest Naczelnik Trzeciego Urzędu Skarbowego Warszawa-Śródmieście w Warszawie.  </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <xsl:if test="ns1:* | pkoprg:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <span class="nag1">A.WŁAŚCIWY ORGAN I CEL SKŁADANIA DEKLARACJI</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="46"/> <td colspan="2"> <b>6. Naczelnik urzędu skarbowego :</b> <br/> <span class="cz18"> <xsl:value-of select="@taxOffice"/> </span> </td> </tr> <tr> <td class="style3" colspan="2"> <b>7. Cel złożenia formularza</b>(zaznaczyć własciwy kwadrat):  </td> </tr> <tr> <td align="left" valign="top" width="422">1. złożenie deklaracji<br/> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> </xsl:if> </td> <td align="left" valign="top" width="471">2. korekta deklaracji<sup>1)</sup> <br/> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> <br/> <!-- <xsl:value-of select="@justification"/> --> </xsl:if> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika"> <xsl:if test="ns1:* | pkoprg:* | ns4:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">B. DANE PODATNIKA</span> </td> </tr> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag2">B.1. DANE IDENTYFIKACYJNE</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="3" height="27" valign="top"> <b>8. Rodzaj podatnika (zaznaczyć właściwy kwadrat): </b> </td> </tr> <tr> <td align="left" valign="top">1. podatnik niebędący osobą fizyczną <br/> <xsl:for-each select=".//ns1:Trader | .//tr:Trader "> <b> <span class="cz18">X</span> </b> </xsl:for-each> </td> <td align="left" valign="top" width="425">2. osoba fizyczna <br/> <xsl:for-each select=".//ns1:PrivatePerson | .//tr:PrivatePerson"> <b> <span class="cz18">X</span> </b> </xsl:for-each> </td> </tr> <tr> <td align="left" colspan="3" valign="top"> <b>9. Nazwa pełna <sup>2)</sup>/Nazwisko, pierwsze imię <sup>3)</sup> </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@fullName"/> </span> <span class="cz18"> <xsl:value-of select="//@REGON"/> </span> <span class="cz18"> <xsl:value-of select="//@firstName"/> </span> <span class="cz18"> <xsl:value-of select="//@surname"/> </span> <span class="cz18"> <xsl:value-of select="//@dateOfBirth"/> </span> <span class="cz18"> <xsl:value-of select="//@PESEL"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:template match="*" mode="Adres"> <xsl:if test="ns1:* | pkoprg:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="6"> <span class="nag2">B.2. ADRES SIEDZIBY <sup> 2)</sup>/ ADRES ZAMIESZKANIA <sup>3)</sup> </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td width="269"> <b>10. Kraj </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2"> <b>11. Województwo</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceName"/> </span> </td> <td colspan="2"> <b>12. Powiat</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>13. Gmina </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@communeName"/> </span> </td> <td colspan="2"> <b>14. Ulica</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> <td width="144"> <b>15. Nr domu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td width="151"> <b>16. Nr lokalu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> </tr> <tr align="left" valign="top"> <td> <b>17. Miejscowość</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <td colspan="2"> <b>18. Kod pocztowy</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> <!-- <td colspan="2"> <b>19. Poczta</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalName"/> </span> </td> --> <td colspan="2"> <b>19. Poczta</b> <br/> <span class="cz18"> <xsl:value-of select=".//@postalName"/> </span> <br/> </td> </tr> </table> <table width="955"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">P-KOP/RG</span> <sub style="cz9">(2)</sub> <b style="nag1">/1</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. WYROBOW --> <xsl:template match="ns1:* | pkoprg:*" mode="WyrobyG"> <!-- ZNAK KONCA STRONY DO WYDRUKU --> <div style="page-break-before: always"/> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag1" colspan="6">C. OBLICZENIE WYSOKOŚCI PODATKU OD WYDOBYCIA NIEKTÓRYCH KOPALIN</td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag2" colspan="6">C.1 OBLICZENIE KWOT PODATKU OD GAZU ZIEMNEGO</td> </tr> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td width="179">Nazwa kopaliny</td> <td width="139">Ilość gazu ziemnego wyrażona w megatowagodzinach<sup>4)</sup> </td> <td width="159">Średnia cena gazu ziemnego</td> <td width="159">Wartość wydobytego gazu ziemnego<sup>5)</sup> </td> <td width="159">Stawka podatku </td> <td width="159">Kwota podatku w zł<sup>6)</sup> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td> <div align="center">a</div> </td> <td> <div align="center">b</div> </td> <td> <div align="center">c</div> </td> <td> <div align="center">d</div> </td> <td> <div align="center">e</div> </td> <td> <div align="center">f</div> </td> </tr> <xsl:for-each select="//ns1:CalcTax | //pkoprg:CalcTax"> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Gaz ziemny, o którym mowa w art. 7a ust.4 ustawy</div> </td> <td> <b class="cz10">20.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxA/@numberOfGoods"/> </div> </td> <td bgcolor="#CCCCCC"> <div align="right" class="cz14" valign="top"> <!--<xsl:value-of select=".//ns1:CalcGasTaxA/@averagePrice"/>--> </div> </td> <td> <b align="left" class="cz10" valign="top">21.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxA/@valueOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">22.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxA/@taxRate"/> </div> </td> <td> <b align="left" class="cz10" valign="top">23.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcGasTaxA/@amountOfTax),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Gaz ziemny, o którym mowa w art. 7a ust.6 pkt 1 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">24.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxB/@numberOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">25.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxB/@averagePrice"/> </div> </td> <td> <b align="left" class="cz10" valign="top">26.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxB/@valueOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">27.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxB/@taxRate"/> </div> </td> <td> <b align="left" class="cz10" valign="top">28.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcGasTaxB/@amountOfTax),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Gaz ziemny, o którym mowa w art. 7a ust.6 pkt 2 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">29.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxC/@numberOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">30.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxC/@averagePrice"/> </div> </td> <td> <b align="left" class="cz10" valign="top">31.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxC/@valueOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">32.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxC/@taxRate"/> </div> </td> <td> <b align="left" class="cz10" valign="top">33.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcGasTaxC/@amountOfTax),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Gaz ziemny, o którym mowa w art. 7a ust.8 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">34.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxD/@numberOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">35.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxD/@averagePrice"/> </div> </td> <td> <b align="left" class="cz10" valign="top">36.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxD/@valueOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">37.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxD/@taxRate"/> </div> </td> <td> <b align="left" class="cz10" valign="top">38.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcGasTaxD/@amountOfTax),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" colspan="5"> <b>Gaz ziemny-kwota podatku</b> <br/>Suma kwot z poz. 23, 28, 33, 38</td> <td> <b align="left" class="cz10" valign="top">39.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//@totalAmountOfGasTax),'# ##0')"/> </div> </td> </tr> </xsl:for-each> </table> </xsl:template> <!-- SZABLON DOT. WYROBOW --> <xsl:template match="ns1:* | pkoprg:*" mode="WyrobyN"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag2" colspan="6">C.2 OBLICZENIE KWOT PODATKU OD ROPY NAFTOWEJ</td> </tr> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td width="179">Nazwa kopaliny</td> <td width="139">Ilość ropy naftowej wyrażona w tonach<sup>7)</sup> </td> <td width="159">Średnia cena ropy naftowej</td> <td width="159">Wartość wydobytej ropy naftowej<sup>5)</sup> </td> <td width="159">Stawka podatku </td> <td width="159">Kwota podatku w zł<sup>6)</sup> </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td> <div align="center">a</div> </td> <td> <div align="center">b</div> </td> <td> <div align="center">c</div> </td> <td> <div align="center">d</div> </td> <td> <div align="center">e</div> </td> <td> <div align="center">f</div> </td> </tr> <xsl:for-each select="//ns1:CalcTax | //pkoprg:CalcTax"> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Ropa naftowa, o której mowa w art. 7a ust.7 pkt 1 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">40.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxA /@numberOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">41.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxA /@averagePrice"/> </div> </td> <td> <b align="left" class="cz10" valign="top">42.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxA /@valueOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">43.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxA /@taxRate"/> </div> </td> <td> <b align="left" class="cz10" valign="top">44.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcOilTaxA /@amountOfTax),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Ropa naftowa, o której mowa w art. 7a ust.7 pkt 2 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">45.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxB/@numberOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">46.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxB/@averagePrice"/> </div> </td> <td> <b align="left" class="cz10" valign="top">47.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxB/@valueOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">48.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxB/@taxRate"/> </div> </td> <td> <b align="left" class="cz10" valign="top">49.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcOilTaxB/@amountOfTax),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Ropa naftowa, o którEJ mowa w art. 7a ust.8 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">50.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxC/@numberOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">51.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxC/@averagePrice"/> </div> </td> <td> <b align="left" class="cz10" valign="top">52.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxC/@valueOfGoods"/> </div> </td> <td> <b align="left" class="cz10" valign="top">53.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxC/@taxRate"/> </div> </td> <td> <b align="left" class="cz10" valign="top">54.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcOilTaxC/@amountOfTax),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" colspan="5"> <b>Ropa natowa - kwota podatku </b> <br/>Suma kwot z poz. 44, 49, 54</td> <td> <b align="left" class="cz10" valign="top">55.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//@totalAmountOfOilTax),'# ##0')"/> </div> </td> </tr> </xsl:for-each> </table> </xsl:template> <!-- SZABLON DOT. KWOTY PODATKU --> <xsl:template match="ns1:Header | pkoprg:*" mode="KwotaPodatku"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td class="nag1" colspan="6">D. WYSOKOŚĆ PODATKU OD WYDOBYCIA NIEKTÓRYCH KOPALIN PO UWZGLĘDNIENIU ZWOLNIEŃ I ODLICZEŃ</td> </tr> <tr align="center" bgcolor="#CCCCCC" valign="middle"> <td width="109">Nazwa kopaliny</td> <td width="159">kwota podatku wyliczona odpowiednio w cześci C1. i C.2.</td> <td width="169">Kwota zwolonienia od podatku na podstawie art. 7b ustawy</td> <td width="209">Kwota podatku po uwzględnieniu kwoty zwolnienia w zł<sup>5)</sup>Od kwoty w kolumnie b należy odjąć kwotę z kolumny c</td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td> <div align="center">a</div> </td> <td> <div align="center">b</div> </td> <td> <div align="center">c</div> </td> <td> <div align="center">d</div> </td> </tr> <xsl:for-each select="//ns1:CalcTaxAfterReductions | //pkoprg:CalcTaxAfterReductions"> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Gaz ziemny, o którym mowa w art. 7a ust.4 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">56.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxAR/@amountOfTax"/> </div> </td> <td> <b align="left" class="cz10" valign="top">57.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxAR/@amountOfReduction"/> </div> </td> <td> <b align="left" class="cz10" valign="top">58.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcGasTaxAR/@amountOfTaxAfterReduction),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Gaz ziemny, o którym mowa w art. 7a ust.6 pkt 1 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">59.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxBR/@amountOfTax"/> </div> </td> <td> <b align="left" class="cz10" valign="top">60.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxBR/@amountOfReduction"/> </div> </td> <td> <b align="left" class="cz10" valign="top">61.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcGasTaxBR/@amountOfTaxAfterReduction),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Gaz ziemny, o którym mowa w art. 7a ust.6 pkt 2 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">62.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxCR/@amountOfTax"/> </div> </td> <td> <b align="left" class="cz10" valign="top">63.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxCR/@amountOfReduction"/> </div> </td> <td> <b align="left" class="cz10" valign="top">64.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcGasTaxCR/@amountOfTaxAfterReduction),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Gaz ziemny, o którym mowa w art. 7a ust.8 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">65.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxDR/@amountOfTax"/> </div> </td> <td> <b align="left" class="cz10" valign="top">66.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcGasTaxDR/@amountOfReduction"/> </div> </td> <td> <b align="left" class="cz10" valign="top">67.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcGasTaxDR/@amountOfTaxAfterReduction),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" colspan="3"> <b>Gaz ziemny ogółem po odliczeniu zwolnienia</b> <br/>Suma kwot z poz. 58,61,64,67</td> <td> <b align="left" class="cz10" valign="top">68.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//@totalAmountOfGasTaxAfterReductions),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Ropa naftowa, o której mowa w art. 7a ust.7 pkt 1 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">69.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxAR/@amountOfTax"/> </div> </td> <td> <b align="left" class="cz10" valign="top">70.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxAR/@amountOfReduction"/> </div> </td> <td> <b align="left" class="cz10" valign="top">71.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcOilTaxAR/@amountOfTaxAfterReduction),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Ropa naftowa, o której mowa w art. 7a ust.7 pkt 2 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">72.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxBR/@amountOfTax"/> </div> </td> <td> <b align="left" class="cz10" valign="top">73.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxBR/@amountOfReduction"/> </div> </td> <td> <b align="left" class="cz10" valign="top">74.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcOilTaxBR/@amountOfTaxAfterReduction),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td> <div align="right" class="cz10" valign="top">Ropa naftowa, o której mowa w art. 7a ust.8 ustawy</div> </td> <td> <b align="left" class="cz10" valign="top">75.</b> <br/> <div align="left" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxCR/@amountOfTax"/> </div> </td> <td> <b align="left" class="cz10" valign="top">76.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select=".//ns1:CalcOilTaxCR/@amountOfReduction"/> </div> </td> <td> <b align="left" class="cz10" valign="top">77.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//ns1:CalcOilTaxCR/@amountOfTaxAfterReduction),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" colspan="3"> <b>Ropa naftowa ogółem po odliczeniu zwolnienia</b> <br/>Suma kwot z poz. 71, 74, 77</td> <td> <b align="left" class="cz10" valign="top">78.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//@totalAmountOfOilTaxAfterReductions),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" colspan="3"> <b>Wysokość skumulowanej straty podatkowej, o której mowa w art. 10a ust. 1 ustawy</b> </td> <td> <b align="left" class="cz10" valign="top">79.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//@totalTaxLoss),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" colspan="3"> <b>Kwota odliczenia wynikającego z art. 10a ust. 1 ustawy</b> </td> <td> <b align="left" class="cz10" valign="top">80.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//@amountOfReduction),'# ##0')"/> </div> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" colspan="3"> <b>Podatek do zapłaty<sup>*) 6)</sup> </b> <br/>Suma kwot z poz. 68 i 78 pomniejszona o kwotę z poz. 80. Jeżeli różnica jest liczbą ujemna, należy wpisać 0.<br/>Zgodnie z art. 35 ust. 2 ustawy z dnia 25 lipca 2014 r. o specjalnym podatku węglowodorowym (Dz.U. z 2018r. poz. 246), obowiązek zapłaty podatku od wydobycia niekórych kopalin, w zakresie wydobycia gazu ziemnego i ropy natowej, powstaje od gazu ziemnego i ropy naftowej wydobytych od dnia 1 stycznia 2020 r.</td> <td> <b align="left" class="cz10" valign="top">81.</b> <br/> <div align="right" class="cz14" valign="top"> <xsl:value-of select="format-number(number(.//@toPay),'# ##0')"/> </div> </td> </tr> </xsl:for-each> </table> </xsl:template> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:* | pkoprg:* | tp:*"> <table border="1" height="210" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <b> <span class="nag1">E. PODPIS PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span> </b> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td height="37" width="402"> <b>82. Imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> <td width="491"> <b>83. Nazwisko </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname "/> </span> </td> </tr> <tr align="left" valign="top"> <td height="39"> <b>84. Data wypełnienia deklaracji (dzień-miesiąc-rok) </b> <br/> <br/> <br/> <span class="cz18"> <xsl:value-of select="substring(//@declarationDate,1,4)"/> <xsl:value-of select="substring(//@declarationDate,5,6)"/> </span> </td> <td> <b>85. Podpis podatnika lub osoby reprezentującej podatnika </b> </td> </tr> <tr align="left" valign="top"> <td colspan="2" height="70"> <b>86. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika<sup>8)</sup> </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@phone"/>, <xsl:value-of select="ns1:Statement/ns3:representative/@email"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADNOTACJI--> <xsl:template match="*" mode="Adnotacje"> <xsl:if test="ns1:* | pkoprg:*"> <table border="1" height="167" width="955"> <tr bgcolor="#CCCCCC"> <td class="nag1" colspan="3" height="36">F. ADNOTACJE URZĘDU CELNEGO </td> </tr> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td rowspan="2" width="40"/> <td colspan="2" height="72"> <b>87. Uwagi urzędu celnego <br/> <br/> <br/> <br/> <br/> <br/> <br/> </b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--> <xsl:template match="*" mode="ObjasnieniaAkc"> <xsl:if test="ns1:* | pkoprg:*"> <table width="955"> <tr> <td> <p align="center"> <b>Objaśnienia:</b> <b/> </p> <p> <sup>1)</sup> Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2017 r. poz. 201, z późn.zm).<br/> <sup>2)</sup> Dotyczy podmiotów niebędących osobami fizycznymi.<br/> <sup>3)</sup> Dotyczy podmiotów będących osobami fizycznymi.<br/> <sup>4)</sup> W przypadku megawatogodzin ilość podaje się z dokładnością do dwóch miejsc po przecinku.<br/> <sup>4)</sup> Wartość wydobytego gazu ziemnego lub ropy naftowej wyraża się w złotych, zaokrąglając w górę z dokładnością do jednego złotego.<br/> <sup>6)</sup> Kwoty podatków zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa.<br/> <sup>7)</sup>W przypadku ton ilość podaje się z dokładnością do dwóch miejsc po przecinku.<br/> <sup>8)</sup>Podanie informacji jest dobrowolne.<br/> </p> <p align="center"> <b> Pouczenie: </b> </p> <p>*)W przypadku niewpłacenia w obowiązującym terminie kwoty z poz. 81 lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2017 r. poz. 1201, z późn. zm.). Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym. </p> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1">P-KOP/RG</span> <sub style="cz9">(2)</sub> <b style="nag1">/3</b> </td> </tr> </table> </xsl:if> </xsl:template> <!-- KONIEC all AG--> </xsl:stylesheet>